## Overview
This code contains the implementation of the **Multi-view Human Cognitive Distribution Calibration (MHC-DC)** framework, a Bayesian relational inference approach for few-shot learning inspired by human cognitive mechanisms. The model emulates human two-phase thinking (fast pattern matching and slow probabilistic reasoning) through:
1. **Attention-based Mixture-of-Experts (MoE)** for dynamic knowledge allocation
2. **Bayesian multi-view Gaussian relational graphs** for interpretable reasoning



### Key Files

| File                       | Description                                                 |
| :------------------------- | :---------------------------------------------------------- |
| `main.py`                  | Entry point for training/evaluation                         |
| `MoE_RIM.py`               | Core model implementation (MoE + Bayesian relation modules) |
| `data_loader.py`           | Base Dataset loading and preprocessing                      |
| `Utils.py`                 | Training loops and evaluation metrics                       |
| `miniImagenetOneShot.py`   | miniImagenet Dataset loading and preprocessing              |
| `tieredImagenetOneShot.py` | tieredImagenet&DermNet Dataset loading and preprocessing    |



## Quick Start for *Mini*Imagenet

1. Download and place under `./mini-imagenet/` with `train.csv/val.csv/test.csv` and `images/` folder.

2. Run the main script with default settings: 

   ```
   python main.py
   ```

   Modify `args` in `main.py` for custom settings:

```
args = {
    'dataset': 'miniImagenet',  # or 'tieredImagenet'
    'n_way': 5,                 # Number of classes per episode
    'n_shot': 1,                # Support samples per class
    'n_query': 5,               # Query samples per class
    'n_gaus': 100,              # Number of Gaussian relation views
    'experts': 3,               # MoE experts count
    'classifier': 'LogisticRegression'  # Options: NN/SVM/RF/KNN/XGBoost
}
```

